#!/bin/bash

echo "SCRIPTS_HOME = ${SCRIPTS_HOME}"
echo "WEBLOGIC_USER_HOME = ${WEBLOGIC_USER_HOME}"

id -u "weblogic"
if ! [ id -u "weblogic" >/dev/null 2>&1 ]; then
	echo "Creating user weblogic."
	useradd weblogic --user-group --password weblogic1
else
	echo "User exists."
fi

# Setup my environment
. ${SCRIPTS_HOME}/${DOMAIN_NAME}.profile

echo "JDK INSTALL LOCATION=${JDK_INSTALL_LOCATION}"

# Setup the profile for the weblogic user
cp ${SCRIPTS_HOME}/${DOMAIN_NAME}.profile ${WEBLOGIC_USER_HOME}/.bash_profile
sed -i.bak "s,JDK_INSTALL_LOCATION,${JDK_INSTALL_LOCATION},g" ${WEBLOGIC_USER_HOME}/.bash_profile
chown weblogic:"$ORACLE_INSTALL_GROUP" ${WEBLOGIC_USER_HOME}/.bash_profile

# Setup the environment properties
cp ${SCRIPTS_HOME}/${DOMAIN_NAME}.properties ${WEBLOGIC_USER_HOME}/
sed -i.bak "s/DEVID/${MHV_DB_ID}/g;s/DB_INFO/${MHV_DB_INFO}/g" ${WEBLOGIC_USER_HOME}/${DOMAIN_NAME}.properties
chown weblogic:"$ORACLE_INSTALL_GROUP" ${WEBLOGIC_USER_HOME}/${DOMAIN_NAME}.properties

if [ ! -d "/u01/app" ]; then
  mkdir -p /u01/app
fi

if [ ! -d "/usr/java" ]; then
  mkdir -p /usr/java
fi

if [ ! -d ${JAVA_HOME} ]; then

	if [ ! -f ${SOFTWARE_DIRECTORY}/${JDK_FILENAME} ]; then
		# Download the file from the tools server.
		echo "Downloading file ${BASE_TOOLS_URL}/java/${JDK_FILENAME}."
		wget -q --tries=20 --continue --retry-connrefused --waitretry=5 --read-timeout=20 ${BASE_TOOLS_URL}/java/${JDK_FILENAME} -O ${SOFTWARE_DIRECTORY}/${JDK_FILENAME}
		
		if [ $? -ne 0 ]; then
			echo "Error Downloading File: ${JDK_FILENAME} from location ${BASE_TOOLS_URL}/java. Check network connectivity and file existence and then retry."
			exit $?
		fi
	fi

	echo "Extracting JDK..."
	tar zxvf ${SOFTWARE_DIRECTORY}/${JDK_FILENAME} -C /usr/java
fi

# Download the WebLogic installer if not present.
if [ ! -f ${SOFTWARE_DIRECTORY}/${WEBLOGIC_FILE_NAME} ]; then
	# Download the file from the tools server.
	echo "Downloading file ${BASE_TOOLS_URL}/appServer/${WEBLOGIC_FILE_NAME}."
	wget -q --tries=20 --continue --retry-connrefused --waitretry=5 --read-timeout=20 ${BASE_TOOLS_URL}/appServer/${WEBLOGIC_FILE_NAME} -O ${SOFTWARE_DIRECTORY}/${WEBLOGIC_FILE_NAME}
	
	if [ $? -ne 0 ]; then
		echo "Error Downloading File: ${WEBLOGIC_FILE_NAME} from location ${BASE_TOOLS_URL}/appServer. Check network connectivity and file existence and then retry."
		exit $?
	fi
fi

if [ ! -d "/u01/tmp" ]; then
	mkdir /u01/tmp
fi

if [ ! -d "/u01/app/oracle" ]; then
	mkdir /u01/app/oracle 
fi

if [ ! -d "/u01/app/domains" ]; then
	mkdir /u01/app/domains 
fi

if [ ! -d "/u01/app/scripts" ]; then
	mkdir /u01/app/scripts
else
    rm -rf /u01/app/scripts/*
fi

cp -R ${SCRIPTS_HOME}/../wlst/* /u01/app/scripts/ 

if [ ! -d "/u01/app/keystore" ]; then
	mkdir /u01/app/keystore
else
    rm -rf /u01/app/keystore/*
fi

if [ ! -f ${SOFTWARE_DIRECTORY}/MHV.jks ]; then
	# Download the file from the tools server.
	echo "Downloading file ${BASE_TOOLS_URL}/mhv/MHV.jks."
	wget -q --tries=20 --continue --retry-connrefused --waitretry=5 --read-timeout=20 ${BASE_TOOLS_URL}/mhv/MHV.jks -O ${SOFTWARE_DIRECTORY}/MHV.jks
	
	if [ $? -ne 0 ]; then
		echo "Error Downloading File: MHV.jks from location ${BASE_TOOLS_URL}/mhv. Check network connectivity and file existence and then retry."
		exit $?
	fi
fi

cp ${SOFTWARE_DIRECTORY}/MHV.jks /u01/app/keystore/

if [ $DOMAIN_NAME == "services.dev" ]; then
	if [ ! -d "/u01/app/mock" ]; then
		mkdir /u01/app/mock
		cp ${SOFTWARE_DIRECTORY}/Mockey.jar /u01/app/mock/ 
	fi
fi

chown -R weblogic:"$ORACLE_INSTALL_GROUP" /u01/app
chown -R weblogic:"$ORACLE_INSTALL_GROUP" /u01/tmp

if [ ! -d "/home/weblogic/${JAVA_PREFS_FILENAME}" ]; then
	mkdir -p /home/weblogic/${JAVA_PREFS_FILENAME}/.systemPrefs
	mkdir -p /home/weblogic/${JAVA_PREFS_FILENAME}/.userPrefs
	chown -R weblogic:"$ORACLE_INSTALL_GROUP" /home/weblogic/${JAVA_PREFS_FILENAME}
	chmod -R 755 /home/weblogic/${JAVA_PREFS_FILENAME}/
fi

yum install -y  rng-tools.x86_64
cp /vagrant/services/rngd.conf /etc/sysconfig/rngd
chkconfig rngd on
service rngd start

# disable iptables on boot so that we can get to our servers
chkconfig iptables off
/etc/init.d/iptables save
/etc/init.d/iptables stop

exit $?

	
